<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

require_once 'db.php';

$response = ['status' => 'error', 'message' => '', 'data' => []];

try {
    // Query to get all active blogs with SEO data
    $sql = "SELECT 
                b.blog_id,
                b.Blog_Title AS title,
                b.Category AS category,
                b.date AS pastdate,
                b.start_time AS starttime,
                b.end_time AS endtime,
                b.location,
                b.description,
                b.Blog_image AS images,
                s.Seo_title,
                s.Seo_description
            FROM blogs b
            LEFT JOIN blog_seo s ON b.blog_id = s.Blog_id
            WHERE b.Delete_status = 0";

    $result = $conn->query($sql);
    
    if ($result) {
        $blogs = [];
        while ($row = $result->fetch_assoc()) {
            // Decode the JSON image paths if they exist
            if (!empty($row['images'])) {
                $row['images'] = json_decode($row['images'], true);
            } else {
                $row['images'] = [];
            }
            $blogs[] = $row;
        }
        
        $response = [
            'status' => 'success',
            'message' => 'Blogs retrieved successfully',
            'data' => $blogs,
            'count' => count($blogs)
        ];
    } else {
        throw new Exception("Database error: " . $conn->error);
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}
?>